const app = document.getElementById('app');

function ensureAdmin() {
  if (!window.currentUser || (window.currentUser.role||'').toLowerCase() !== 'admin') {
    alert('Recurso permitido apenas para administradores.');
    return false;
  }
  return true;
}

function renderLogin() {
  app.innerHTML = `
    <div class="card">
      <h2>Login</h2>
      <input id="email" placeholder="E-mail" style="display:block;margin-bottom:8px;width:280px;">
      <input id="password" type="password" placeholder="Senha" style="display:block;margin-bottom:8px;width:280px;">
      <button id="doLogin">Entrar</button>
      <div id="loginMsg" style="margin-top:8px;color:#c00;"></div>
    </div>
  `;
  document.getElementById('doLogin').onclick = async () => {
    const email = document.getElementById('email').value.trim();
    const password = document.getElementById('password').value;
    try {
      const profile = await API.login(email, password);
      window.currentUser = profile;
      alert(`Bem-vinda, ${profile.name} (${profile.role})`);
      renderProducts();
    } catch (e) {
      document.getElementById('loginMsg').textContent = e.message || 'Falha no login';
    }
  };
}

async function renderProducts() {
  app.innerHTML = `
    <div class="card">
      <h2>Produtos</h2>
      <div style="margin-bottom:10px;">
        <input id="q" placeholder="Buscar por nome/categoria" style="width:300px;">
        <button id="search">Buscar</button>
        <button id="newProd">Novo produto</button>
      </div>
      <div id="list"></div>
    </div>
  `;
  const load = async () => {
    const q = document.getElementById('q').value.trim();
    const rows = await API.listProducts(q);
    const html = `
      <table>
        <thead><tr>
          <th>Nome</th><th>Categoria</th><th>Preço</th><th>Qtd</th><th>Status</th><th>Ações</th>
        </tr></thead>
        <tbody>
          ${rows.map(r => `
            <tr>
              <td>${r.name ?? ''}</td>
              <td>${r.category ?? ''}</td>
              <td>${Number(r.sale_price ?? 0).toFixed(2)}</td>
              <td>${r.quantity ?? 0}</td>
              <td>${r.status ?? ''}</td>
              <td>
                <button data-edit="${r.id}">Editar</button>
                <button data-del="${r.id}">Excluir</button>
              </td>
            </tr>
          `).join('')}
        </tbody>
      </table>
    `;
    document.getElementById('list').innerHTML = html;
    document.querySelectorAll('[data-edit]').forEach(btn => {
      btn.onclick = () => {
        if (!ensureAdmin()) return;
        renderProductForm(btn.getAttribute('data-edit'));
      };
    });
    document.querySelectorAll('[data-del]').forEach(btn => {
      btn.onclick = async () => {
        if (!ensureAdmin()) return;
        if (confirm('Excluir produto?')) {
          await API.deleteProduct(btn.getAttribute('data-del'));
          load();
        }
      };
    });
  };
  document.getElementById('search').onclick = load;
  document.getElementById('newProd').onclick = () => {
    if (!ensureAdmin()) return;
    renderProductForm();
  };
  load();
}

async function renderProductForm(id) {
  let item = { name:'', description:'', category:'', cost_price:0, sale_price:0, quantity:0, status:'active' };
  const rows = await API.listProducts();
  if (id) item = rows.find(x => x.id === id) || item;
  app.innerHTML = `
    <div class="card">
      <h2>${id ? 'Editar' : 'Novo'} Produto</h2>
      <div style="display:grid;gap:8px;max-width:420px;">
        <input id="name" placeholder="Nome" value="${item.name ?? ''}">
        <input id="category" placeholder="Categoria" value="${item.category ?? ''}">
        <input id="sale_price" type="number" step="0.01" placeholder="Preço venda" value="${item.sale_price ?? 0}">
        <input id="quantity" type="number" placeholder="Quantidade" value="${item.quantity ?? 0}">
        <select id="status">
          <option value="active" ${item.status==='active'?'selected':''}>Ativo</option>
          <option value="inactive" ${item.status==='inactive'?'selected':''}>Inativo</option>
        </select>
        <textarea id="description" placeholder="Descrição">${item.description ?? ''}</textarea>
        <button id="save">Salvar</button>
        <button id="back">Voltar</button>
      </div>
    </div>
  `;
  document.getElementById('save').onclick = async () => {
    const payload = {
      id,
      name: document.getElementById('name').value.trim(),
      category: document.getElementById('category').value.trim(),
      sale_price: Number(document.getElementById('sale_price').value || 0),
      quantity: Number(document.getElementById('quantity').value || 0),
      status: document.getElementById('status').value,
      description: document.getElementById('description').value
    };
    await API.saveProduct(payload);
    renderProducts();
  };
  document.getElementById('back').onclick = renderProducts;
}

async function renderMovements() {
  app.innerHTML = `
    <div class="card">
      <h2>Histórico de Movimentações</h2>
      <div id="hist"></div>
    </div>
  `;
  const rows = await API.listMovements();
  document.getElementById('hist').innerHTML = `
    <table>
      <thead><tr><th>Data</th><th>Tipo</th><th>Produto</th><th>Qtd</th><th>Usuário</th></tr></thead>
      <tbody>
        ${rows.map(r => `
          <tr>
            <td>${new Date(r.created_at).toLocaleString()}</td>
            <td>${r.type}</td>
            <td>${r.product_name ?? ''}</td>
            <td>${r.quantity}</td>
            <td>${r.user_name ?? ''}</td>
          </tr>
        `).join('')}
      </tbody>
    </table>
  `;
}

// navegação simples
document.getElementById('nav-login').onclick = renderLogin;
document.getElementById('nav-products').onclick = renderProducts;
document.getElementById('nav-movements').onclick = renderMovements;

// tela inicial
renderLogin();
