const API = {
  base: '/api', // ajuste se sua pasta não for /api

  token: null,

  setToken(jwt) { this.token = jwt; },
  authHeaders() {
    return this.token ? { 'Authorization': `Bearer ${this.token}` } : {};
  },

  async login(email, password) {
    const r = await fetch(`${this.base}/auth.php`, {
      method: 'POST',
      headers: {'Content-Type':'application/json'},
      body: JSON.stringify({ email, password })
    });
    if (!r.ok) throw new Error('Login inválido');
    const data = await r.json();
    this.setToken(data.token);
    return data.profile; // {id, name, email, role}
  },

  async listProducts(q='') {
    const url = q ? `${this.base}/products.php?q=${encodeURIComponent(q)}` : `${this.base}/products.php`;
    const r = await fetch(url);
    if (!r.ok) throw new Error('Falha ao listar produtos');
    return r.json();
  },

  async saveProduct(product) {
    const r = await fetch(`${this.base}/products.php`, {
      method: product.id ? 'PUT' : 'POST',
      headers: { 'Content-Type':'application/json', ...this.authHeaders() },
      body: JSON.stringify(product)
    });
    if (!r.ok) {
      const t = await r.text().catch(()=>'');
      throw new Error('Falha ao salvar produto: ' + t);
    }
    return r.json();
  },

  async deleteProduct(id) {
    const r = await fetch(`${this.base}/products.php?id=${encodeURIComponent(id)}`, {
      method: 'DELETE',
      headers: this.authHeaders()
    });
    if (!r.ok) throw new Error('Falha ao excluir produto');
    return r.json();
  },

  async listMovements() {
    const r = await fetch(`${this.base}/movements.php`);
    if (!r.ok) throw new Error('Falha ao listar movimentações');
    return r.json();
  },

  async moveStock({ product_id, type, quantity }) {
    const r = await fetch(`${this.base}/movements.php`, {
      method: 'POST',
      headers: {'Content-Type':'application/json', ...this.authHeaders()},
      body: JSON.stringify({ product_id, type, quantity })
    });
    if (!r.ok) {
      const t = await r.text().catch(()=>'');
      throw new Error('Falha ao movimentar estoque: ' + t);
    }
    return r.json();
  }
};
