<?php
require __DIR__ . '/cors.php';
require __DIR__ . '/db.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
  $q = $_GET['q'] ?? '';
  if ($q !== '') {
    $stmt = $pdo->prepare("SELECT id, name, category, sale_price, quantity, status FROM public.products
                           WHERE lower(name) LIKE lower(:q) OR lower(category) LIKE lower(:q)
                           ORDER BY name ASC");
    $stmt->execute([':q' => "%$q%"]);
  } else {
    $stmt = $pdo->query("SELECT id, name, category, sale_price, quantity, status FROM public.products ORDER BY name ASC");
  }
  echo json_encode($stmt->fetchAll());
  exit;
}

$payload = json_input();

$auth = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$claims = $auth ? json_decode(base64_decode(str_replace('Bearer ', '', $auth)), true) : null;
$isAdmin = $claims && isset($claims['role']) && strtolower($claims['role']) === 'admin';

if (!$isAdmin) {
  http_response_code(403);
  echo json_encode(['error' => 'Acesso negado (admin apenas)']);
  exit;
}

if ($method === 'POST') {
  $stmt = $pdo->prepare("INSERT INTO public.products (id, name, description, category, cost_price, sale_price, quantity, status, created_at, updated_at)
                         VALUES (gen_random_uuid(), :name, :description, :category, :cost_price, :sale_price, :quantity, :status, now(), now())
                         RETURNING id");
  $stmt->execute([
    ':name' => $payload['name'] ?? '',
    ':description' => $payload['description'] ?? '',
    ':category' => $payload['category'] ?? '',
    ':cost_price' => $payload['cost_price'] ?? 0,
    ':sale_price' => $payload['sale_price'] ?? 0,
    ':quantity' => $payload['quantity'] ?? 0,
    ':status' => $payload['status'] ?? 'active'
  ]);
  echo json_encode(['id' => $stmt->fetchColumn()]);
  exit;
}

if ($method === 'PUT') {
  $id = $payload['id'] ?? '';
  if (!$id) { http_response_code(400); echo json_encode(['error'=>'id obrigatório']); exit; }
  $stmt = $pdo->prepare("UPDATE public.products
                         SET name=:name, description=:description, category=:category,
                             cost_price=:cost_price, sale_price=:sale_price, quantity=:quantity,
                             status=:status, updated_at=now()
                         WHERE id=:id");
  $stmt->execute([
    ':id' => $id,
    ':name' => $payload['name'] ?? '',
    ':description' => $payload['description'] ?? '',
    ':category' => $payload['category'] ?? '',
    ':cost_price' => $payload['cost_price'] ?? 0,
    ':sale_price' => $payload['sale_price'] ?? 0,
    ':quantity' => $payload['quantity'] ?? 0,
    ':status' => $payload['status'] ?? 'active'
  ]);
  echo json_encode(['ok' => true]);
  exit;
}

if ($method === 'DELETE') {
  $id = $_GET['id'] ?? '';
  if (!$id) { http_response_code(400); echo json_encode(['error'=>'id obrigatório']); exit; }
  $stmt = $pdo->prepare("DELETE FROM public.products WHERE id=:id");
  $stmt->execute([':id' => $id]);
  echo json_encode(['ok' => true]);
  exit;
}

http_response_code(405);
echo json_encode(['error' => 'Método não permitido']);
