<?php
require __DIR__ . '/cors.php';
require __DIR__ . '/db.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
  $stmt = $pdo->query("SELECT sm.id, sm.created_at, sm.quantity, sm.type,
                              p.name AS product_name,
                              pr.name AS user_name
                       FROM public.stock_movements sm
                       LEFT JOIN public.products p ON p.id = sm.product_id
                       LEFT JOIN public.profiles pr ON pr.id = sm.user_id
                       ORDER BY sm.created_at DESC
                       LIMIT 200");
  echo json_encode($stmt->fetchAll());
  exit;
}

$auth = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$claims = $auth ? json_decode(base64_decode(str_replace('Bearer ', '', $auth)), true) : null;
$isAdmin = $claims && isset($claims['role']) && strtolower($claims['role']) === 'admin';
if (!$isAdmin) {
  http_response_code(403);
  echo json_encode(['error' => 'Acesso negado (admin apenas)']);
  exit;
}

if ($method === 'POST') {
  $payload = json_input();
  $type = strtoupper(trim($payload['type'] ?? ''));
  $product_id = $payload['product_id'] ?? '';
  $quantity = (int)($payload['quantity'] ?? 0);
  $user_id = $claims['uid'] ?? null;

  if (!in_array($type, ['ENTRY','EXIT'], true) || !$product_id || $quantity <= 0 || !$user_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Dados inválidos']);
    exit;
  }

  $pdo->beginTransaction();
  try {
    $stmt = $pdo->prepare("INSERT INTO public.stock_movements (id, product_id, user_id, type, quantity, created_at)
                           VALUES (gen_random_uuid(), :product_id, :user_id, :type, :quantity, now())");
    $stmt->execute([
      ':product_id' => $product_id,
      ':user_id'    => $user_id,
      ':type'       => $type,
      ':quantity'   => $quantity
    ]);

    if ($type === 'ENTRY') {
      $pdo->prepare("UPDATE public.products SET quantity = COALESCE(quantity,0) + :q, updated_at=now() WHERE id=:id")
          ->execute([':q' => $quantity, ':id' => $product_id]);
    } else {
      $pdo->prepare("UPDATE public.products SET quantity = GREATEST(COALESCE(quantity,0) - :q, 0), updated_at=now() WHERE id=:id")
          ->execute([':q' => $quantity, ':id' => $product_id]);
    }

    $pdo->commit();
    echo json_encode(['ok' => true]);
  } catch (Throwable $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['error' => 'Falha ao registrar movimento', 'details' => $e->getMessage()]);
  }
  exit;
}

http_response_code(405);
echo json_encode(['error' => 'Método não permitido']);
