<?php
$config = include __DIR__ . '/db.config.php';

$dsn = sprintf(
  'pgsql:host=%s;port=%s;dbname=%s;sslmode=%s',
  $config['host'], $config['port'], $config['dbname'], $config['sslmode']
);

try {
  $pdo = new PDO($dsn, $config['user'], $config['password'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
} catch (PDOException $e) {
  http_response_code(500);
  echo json_encode(['error' => 'DB connection failed', 'details' => $e->getMessage()]);
  exit;
}

function json_input() {
  $raw = file_get_contents('php://input');
  return $raw ? json_decode($raw, true) : [];
}
